# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class WebsiteUser(object):
    _types = {
        "user_id": str,
        "name": str,
        "email": str,
        "external_id": str,
        "mobile": str,
        "mobile_country_code": str,
    }

    def __init__(self, d=None):
        self.user_id: Optional[str] = None
        self.name: Optional[str] = None
        self.email: Optional[str] = None
        self.external_id: Optional[str] = None
        self.mobile: Optional[str] = None
        self.mobile_country_code: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "WebsiteUserBuilder":
        return WebsiteUserBuilder()


class WebsiteUserBuilder(object):
    def __init__(self) -> None:
        self._website_user = WebsiteUser()

    def user_id(self, user_id: str) -> "WebsiteUserBuilder":
        self._website_user.user_id = user_id
        return self

    def name(self, name: str) -> "WebsiteUserBuilder":
        self._website_user.name = name
        return self

    def email(self, email: str) -> "WebsiteUserBuilder":
        self._website_user.email = email
        return self

    def external_id(self, external_id: str) -> "WebsiteUserBuilder":
        self._website_user.external_id = external_id
        return self

    def mobile(self, mobile: str) -> "WebsiteUserBuilder":
        self._website_user.mobile = mobile
        return self

    def mobile_country_code(self, mobile_country_code: str) -> "WebsiteUserBuilder":
        self._website_user.mobile_country_code = mobile_country_code
        return self

    def build(self) -> "WebsiteUser":
        return self._website_user
