# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .bonus_amount import BonusAmount


class WithdrawReferralAccountResponseBody(object):
    _types = {
        "external_order_id": str,
        "trans_time": str,
        "withdrawal_details": BonusAmount,
    }

    def __init__(self, d=None):
        self.external_order_id: Optional[str] = None
        self.trans_time: Optional[str] = None
        self.withdrawal_details: Optional[BonusAmount] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "WithdrawReferralAccountResponseBodyBuilder":
        return WithdrawReferralAccountResponseBodyBuilder()


class WithdrawReferralAccountResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._withdraw_referral_account_response_body = WithdrawReferralAccountResponseBody()

    def external_order_id(self, external_order_id: str) -> "WithdrawReferralAccountResponseBodyBuilder":
        self._withdraw_referral_account_response_body.external_order_id = external_order_id
        return self

    def trans_time(self, trans_time: str) -> "WithdrawReferralAccountResponseBodyBuilder":
        self._withdraw_referral_account_response_body.trans_time = trans_time
        return self

    def withdrawal_details(self, withdrawal_details: BonusAmount) -> "WithdrawReferralAccountResponseBodyBuilder":
        self._withdraw_referral_account_response_body.withdrawal_details = withdrawal_details
        return self

    def build(self) -> "WithdrawReferralAccountResponseBody":
        return self._withdraw_referral_account_response_body
