# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.create_application_request import CreateApplicationRequest
from ..model.create_application_response import CreateApplicationResponse
from ..model.get_application_request import GetApplicationRequest
from ..model.get_application_response import GetApplicationResponse
from ..model.list_application_request import ListApplicationRequest
from ..model.list_application_response import ListApplicationResponse
from ..model.offer_application_request import OfferApplicationRequest
from ..model.offer_application_response import OfferApplicationResponse
from ..model.terminate_application_request import TerminateApplicationRequest
from ..model.terminate_application_response import TerminateApplicationResponse
from ..model.transfer_onboard_application_request import TransferOnboardApplicationRequest
from ..model.transfer_onboard_application_response import TransferOnboardApplicationResponse


class Application(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def create(self, request: CreateApplicationRequest,
               option: Optional[RequestOption] = None) -> CreateApplicationResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateApplicationResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateApplicationResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateApplicationRequest,
                      option: Optional[RequestOption] = None) -> CreateApplicationResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateApplicationResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateApplicationResponse)
        response.raw = resp

        return response

    def get(self, request: GetApplicationRequest, option: Optional[RequestOption] = None) -> GetApplicationResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetApplicationResponse = JSON.unmarshal(str(resp.content, UTF_8), GetApplicationResponse)
        response.raw = resp

        return response

    async def aget(self, request: GetApplicationRequest,
                   option: Optional[RequestOption] = None) -> GetApplicationResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetApplicationResponse = JSON.unmarshal(str(resp.content, UTF_8), GetApplicationResponse)
        response.raw = resp

        return response

    def list(self, request: ListApplicationRequest, option: Optional[RequestOption] = None) -> ListApplicationResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListApplicationResponse = JSON.unmarshal(str(resp.content, UTF_8), ListApplicationResponse)
        response.raw = resp

        return response

    async def alist(self, request: ListApplicationRequest,
                    option: Optional[RequestOption] = None) -> ListApplicationResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListApplicationResponse = JSON.unmarshal(str(resp.content, UTF_8), ListApplicationResponse)
        response.raw = resp

        return response

    def offer(self, request: OfferApplicationRequest,
              option: Optional[RequestOption] = None) -> OfferApplicationResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: OfferApplicationResponse = JSON.unmarshal(str(resp.content, UTF_8), OfferApplicationResponse)
        response.raw = resp

        return response

    async def aoffer(self, request: OfferApplicationRequest,
                     option: Optional[RequestOption] = None) -> OfferApplicationResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: OfferApplicationResponse = JSON.unmarshal(str(resp.content, UTF_8), OfferApplicationResponse)
        response.raw = resp

        return response

    def terminate(self, request: TerminateApplicationRequest,
                  option: Optional[RequestOption] = None) -> TerminateApplicationResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: TerminateApplicationResponse = JSON.unmarshal(str(resp.content, UTF_8), TerminateApplicationResponse)
        response.raw = resp

        return response

    async def aterminate(self, request: TerminateApplicationRequest,
                         option: Optional[RequestOption] = None) -> TerminateApplicationResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: TerminateApplicationResponse = JSON.unmarshal(str(resp.content, UTF_8), TerminateApplicationResponse)
        response.raw = resp

        return response

    def transfer_onboard(self, request: TransferOnboardApplicationRequest,
                         option: Optional[RequestOption] = None) -> TransferOnboardApplicationResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: TransferOnboardApplicationResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                      TransferOnboardApplicationResponse)
        response.raw = resp

        return response

    async def atransfer_onboard(self, request: TransferOnboardApplicationRequest,
                                option: Optional[RequestOption] = None) -> TransferOnboardApplicationResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: TransferOnboardApplicationResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                      TransferOnboardApplicationResponse)
        response.raw = resp

        return response
