# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.get_attachment_request import GetAttachmentRequest
from ..model.get_attachment_response import GetAttachmentResponse
from ..model.preview_attachment_request import PreviewAttachmentRequest
from ..model.preview_attachment_response import PreviewAttachmentResponse


class Attachment(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def get(self, request: GetAttachmentRequest, option: Optional[RequestOption] = None) -> GetAttachmentResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetAttachmentResponse = JSON.unmarshal(str(resp.content, UTF_8), GetAttachmentResponse)
        response.raw = resp

        return response

    async def aget(self, request: GetAttachmentRequest,
                   option: Optional[RequestOption] = None) -> GetAttachmentResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetAttachmentResponse = JSON.unmarshal(str(resp.content, UTF_8), GetAttachmentResponse)
        response.raw = resp

        return response

    def preview(self, request: PreviewAttachmentRequest,
                option: Optional[RequestOption] = None) -> PreviewAttachmentResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: PreviewAttachmentResponse = JSON.unmarshal(str(resp.content, UTF_8), PreviewAttachmentResponse)
        response.raw = resp

        return response

    async def apreview(self, request: PreviewAttachmentRequest,
                       option: Optional[RequestOption] = None) -> PreviewAttachmentResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: PreviewAttachmentResponse = JSON.unmarshal(str(resp.content, UTF_8), PreviewAttachmentResponse)
        response.raw = resp

        return response
