# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.batch_delete_eco_background_check_package_request import BatchDeleteEcoBackgroundCheckPackageRequest
from ..model.batch_delete_eco_background_check_package_response import BatchDeleteEcoBackgroundCheckPackageResponse
from ..model.batch_update_eco_background_check_package_request import BatchUpdateEcoBackgroundCheckPackageRequest
from ..model.batch_update_eco_background_check_package_response import BatchUpdateEcoBackgroundCheckPackageResponse
from ..model.create_eco_background_check_package_request import CreateEcoBackgroundCheckPackageRequest
from ..model.create_eco_background_check_package_response import CreateEcoBackgroundCheckPackageResponse


class EcoBackgroundCheckPackage(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def batch_delete(self, request: BatchDeleteEcoBackgroundCheckPackageRequest,
                     option: Optional[RequestOption] = None) -> BatchDeleteEcoBackgroundCheckPackageResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: BatchDeleteEcoBackgroundCheckPackageResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                                BatchDeleteEcoBackgroundCheckPackageResponse)
        response.raw = resp

        return response

    async def abatch_delete(self, request: BatchDeleteEcoBackgroundCheckPackageRequest,
                            option: Optional[RequestOption] = None) -> BatchDeleteEcoBackgroundCheckPackageResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: BatchDeleteEcoBackgroundCheckPackageResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                                BatchDeleteEcoBackgroundCheckPackageResponse)
        response.raw = resp

        return response

    def batch_update(self, request: BatchUpdateEcoBackgroundCheckPackageRequest,
                     option: Optional[RequestOption] = None) -> BatchUpdateEcoBackgroundCheckPackageResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: BatchUpdateEcoBackgroundCheckPackageResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                                BatchUpdateEcoBackgroundCheckPackageResponse)
        response.raw = resp

        return response

    async def abatch_update(self, request: BatchUpdateEcoBackgroundCheckPackageRequest,
                            option: Optional[RequestOption] = None) -> BatchUpdateEcoBackgroundCheckPackageResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: BatchUpdateEcoBackgroundCheckPackageResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                                BatchUpdateEcoBackgroundCheckPackageResponse)
        response.raw = resp

        return response

    def create(self, request: CreateEcoBackgroundCheckPackageRequest,
               option: Optional[RequestOption] = None) -> CreateEcoBackgroundCheckPackageResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateEcoBackgroundCheckPackageResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                           CreateEcoBackgroundCheckPackageResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateEcoBackgroundCheckPackageRequest,
                      option: Optional[RequestOption] = None) -> CreateEcoBackgroundCheckPackageResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateEcoBackgroundCheckPackageResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                           CreateEcoBackgroundCheckPackageResponse)
        response.raw = resp

        return response
