# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.create_external_application_request import CreateExternalApplicationRequest
from ..model.create_external_application_response import CreateExternalApplicationResponse
from ..model.delete_external_application_request import DeleteExternalApplicationRequest
from ..model.delete_external_application_response import DeleteExternalApplicationResponse
from ..model.update_external_application_request import UpdateExternalApplicationRequest
from ..model.update_external_application_response import UpdateExternalApplicationResponse


class ExternalApplication(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def create(self, request: CreateExternalApplicationRequest,
               option: Optional[RequestOption] = None) -> CreateExternalApplicationResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateExternalApplicationResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     CreateExternalApplicationResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateExternalApplicationRequest,
                      option: Optional[RequestOption] = None) -> CreateExternalApplicationResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateExternalApplicationResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     CreateExternalApplicationResponse)
        response.raw = resp

        return response

    def delete(self, request: DeleteExternalApplicationRequest,
               option: Optional[RequestOption] = None) -> DeleteExternalApplicationResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeleteExternalApplicationResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     DeleteExternalApplicationResponse)
        response.raw = resp

        return response

    async def adelete(self, request: DeleteExternalApplicationRequest,
                      option: Optional[RequestOption] = None) -> DeleteExternalApplicationResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeleteExternalApplicationResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     DeleteExternalApplicationResponse)
        response.raw = resp

        return response

    def update(self, request: UpdateExternalApplicationRequest,
               option: Optional[RequestOption] = None) -> UpdateExternalApplicationResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: UpdateExternalApplicationResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     UpdateExternalApplicationResponse)
        response.raw = resp

        return response

    async def aupdate(self, request: UpdateExternalApplicationRequest,
                      option: Optional[RequestOption] = None) -> UpdateExternalApplicationResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: UpdateExternalApplicationResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     UpdateExternalApplicationResponse)
        response.raw = resp

        return response
