# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.create_referral_account_request import CreateReferralAccountRequest
from ..model.create_referral_account_response import CreateReferralAccountResponse
from ..model.deactivate_referral_account_request import DeactivateReferralAccountRequest
from ..model.deactivate_referral_account_response import DeactivateReferralAccountResponse
from ..model.reconciliation_referral_account_request import ReconciliationReferralAccountRequest
from ..model.reconciliation_referral_account_response import ReconciliationReferralAccountResponse
from ..model.withdraw_referral_account_request import WithdrawReferralAccountRequest
from ..model.withdraw_referral_account_response import WithdrawReferralAccountResponse


class ReferralAccount(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def create(self, request: CreateReferralAccountRequest,
               option: Optional[RequestOption] = None) -> CreateReferralAccountResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateReferralAccountResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                 CreateReferralAccountResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateReferralAccountRequest,
                      option: Optional[RequestOption] = None) -> CreateReferralAccountResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateReferralAccountResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                 CreateReferralAccountResponse)
        response.raw = resp

        return response

    def deactivate(self, request: DeactivateReferralAccountRequest,
                   option: Optional[RequestOption] = None) -> DeactivateReferralAccountResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeactivateReferralAccountResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     DeactivateReferralAccountResponse)
        response.raw = resp

        return response

    async def adeactivate(self, request: DeactivateReferralAccountRequest,
                          option: Optional[RequestOption] = None) -> DeactivateReferralAccountResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeactivateReferralAccountResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     DeactivateReferralAccountResponse)
        response.raw = resp

        return response

    def reconciliation(self, request: ReconciliationReferralAccountRequest,
                       option: Optional[RequestOption] = None) -> ReconciliationReferralAccountResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ReconciliationReferralAccountResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                         ReconciliationReferralAccountResponse)
        response.raw = resp

        return response

    async def areconciliation(self, request: ReconciliationReferralAccountRequest,
                              option: Optional[RequestOption] = None) -> ReconciliationReferralAccountResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ReconciliationReferralAccountResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                         ReconciliationReferralAccountResponse)
        response.raw = resp

        return response

    def withdraw(self, request: WithdrawReferralAccountRequest,
                 option: Optional[RequestOption] = None) -> WithdrawReferralAccountResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: WithdrawReferralAccountResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                   WithdrawReferralAccountResponse)
        response.raw = resp

        return response

    async def awithdraw(self, request: WithdrawReferralAccountRequest,
                        option: Optional[RequestOption] = None) -> WithdrawReferralAccountResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: WithdrawReferralAccountResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                   WithdrawReferralAccountResponse)
        response.raw = resp

        return response
