# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.get_referral_website_job_post_request import GetReferralWebsiteJobPostRequest
from ..model.get_referral_website_job_post_response import GetReferralWebsiteJobPostResponse
from ..model.list_referral_website_job_post_request import ListReferralWebsiteJobPostRequest
from ..model.list_referral_website_job_post_response import ListReferralWebsiteJobPostResponse


class ReferralWebsiteJobPost(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def get(self, request: GetReferralWebsiteJobPostRequest,
            option: Optional[RequestOption] = None) -> GetReferralWebsiteJobPostResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetReferralWebsiteJobPostResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     GetReferralWebsiteJobPostResponse)
        response.raw = resp

        return response

    async def aget(self, request: GetReferralWebsiteJobPostRequest,
                   option: Optional[RequestOption] = None) -> GetReferralWebsiteJobPostResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetReferralWebsiteJobPostResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     GetReferralWebsiteJobPostResponse)
        response.raw = resp

        return response

    def list(self, request: ListReferralWebsiteJobPostRequest,
             option: Optional[RequestOption] = None) -> ListReferralWebsiteJobPostResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListReferralWebsiteJobPostResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                      ListReferralWebsiteJobPostResponse)
        response.raw = resp

        return response

    async def alist(self, request: ListReferralWebsiteJobPostRequest,
                    option: Optional[RequestOption] = None) -> ListReferralWebsiteJobPostResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListReferralWebsiteJobPostResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                      ListReferralWebsiteJobPostResponse)
        response.raw = resp

        return response
