# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .add_managers_chat_managers_request_body import AddManagersChatManagersRequestBody


class AddManagersChatManagersRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.member_id_type: Optional[str] = None
        self.chat_id: Optional[str] = None
        self.request_body: Optional[AddManagersChatManagersRequestBody] = None

    @staticmethod
    def builder() -> "AddManagersChatManagersRequestBuilder":
        return AddManagersChatManagersRequestBuilder()


class AddManagersChatManagersRequestBuilder(object):

    def __init__(self) -> None:
        add_managers_chat_managers_request = AddManagersChatManagersRequest()
        add_managers_chat_managers_request.http_method = HttpMethod.POST
        add_managers_chat_managers_request.uri = "/open-apis/im/v1/chats/:chat_id/managers/add_managers"
        add_managers_chat_managers_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._add_managers_chat_managers_request: AddManagersChatManagersRequest = add_managers_chat_managers_request

    def member_id_type(self, member_id_type: str) -> "AddManagersChatManagersRequestBuilder":
        self._add_managers_chat_managers_request.member_id_type = member_id_type
        self._add_managers_chat_managers_request.add_query("member_id_type", member_id_type)
        return self

    def chat_id(self, chat_id: str) -> "AddManagersChatManagersRequestBuilder":
        self._add_managers_chat_managers_request.chat_id = chat_id
        self._add_managers_chat_managers_request.paths["chat_id"] = str(chat_id)
        return self

    def request_body(self, request_body: AddManagersChatManagersRequestBody) -> "AddManagersChatManagersRequestBuilder":
        self._add_managers_chat_managers_request.request_body = request_body
        self._add_managers_chat_managers_request.body = request_body
        return self

    def build(self) -> AddManagersChatManagersRequest:
        return self._add_managers_chat_managers_request
