# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .user_id import UserId


class ChatMemberUser(object):
    _types = {
        "name": str,
        "tenant_key": str,
        "user_id": UserId,
    }

    def __init__(self, d=None):
        self.name: Optional[str] = None
        self.tenant_key: Optional[str] = None
        self.user_id: Optional[UserId] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ChatMemberUserBuilder":
        return ChatMemberUserBuilder()


class ChatMemberUserBuilder(object):
    def __init__(self) -> None:
        self._chat_member_user = ChatMemberUser()

    def name(self, name: str) -> "ChatMemberUserBuilder":
        self._chat_member_user.name = name
        return self

    def tenant_key(self, tenant_key: str) -> "ChatMemberUserBuilder":
        self._chat_member_user.tenant_key = tenant_key
        return self

    def user_id(self, user_id: UserId) -> "ChatMemberUserBuilder":
        self._chat_member_user.user_id = user_id
        return self

    def build(self) -> "ChatMemberUser":
        return self._chat_member_user
