# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .chat_menu_item import ChatMenuItem
from .chat_menu_second_level import ChatMenuSecondLevel


class ChatMenuTopLevel(object):
    _types = {
        "chat_menu_top_level_id": int,
        "chat_menu_item": ChatMenuItem,
        "children": List[ChatMenuSecondLevel],
    }

    def __init__(self, d=None):
        self.chat_menu_top_level_id: Optional[int] = None
        self.chat_menu_item: Optional[ChatMenuItem] = None
        self.children: Optional[List[ChatMenuSecondLevel]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ChatMenuTopLevelBuilder":
        return ChatMenuTopLevelBuilder()


class ChatMenuTopLevelBuilder(object):
    def __init__(self) -> None:
        self._chat_menu_top_level = ChatMenuTopLevel()

    def chat_menu_top_level_id(self, chat_menu_top_level_id: int) -> "ChatMenuTopLevelBuilder":
        self._chat_menu_top_level.chat_menu_top_level_id = chat_menu_top_level_id
        return self

    def chat_menu_item(self, chat_menu_item: ChatMenuItem) -> "ChatMenuTopLevelBuilder":
        self._chat_menu_top_level.chat_menu_item = chat_menu_item
        return self

    def children(self, children: List[ChatMenuSecondLevel]) -> "ChatMenuTopLevelBuilder":
        self._chat_menu_top_level.children = children
        return self

    def build(self) -> "ChatMenuTopLevel":
        return self._chat_menu_top_level
