# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .chat_tab_config import ChatTabConfig
from .chat_tab_content import ChatTabContent


class ChatTab(object):
    _types = {
        "tab_id": str,
        "tab_name": str,
        "tab_type": str,
        "tab_content": ChatTabContent,
        "tab_config": ChatTabConfig,
    }

    def __init__(self, d=None):
        self.tab_id: Optional[str] = None
        self.tab_name: Optional[str] = None
        self.tab_type: Optional[str] = None
        self.tab_content: Optional[ChatTabContent] = None
        self.tab_config: Optional[ChatTabConfig] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ChatTabBuilder":
        return ChatTabBuilder()


class ChatTabBuilder(object):
    def __init__(self) -> None:
        self._chat_tab = ChatTab()

    def tab_id(self, tab_id: str) -> "ChatTabBuilder":
        self._chat_tab.tab_id = tab_id
        return self

    def tab_name(self, tab_name: str) -> "ChatTabBuilder":
        self._chat_tab.tab_name = tab_name
        return self

    def tab_type(self, tab_type: str) -> "ChatTabBuilder":
        self._chat_tab.tab_type = tab_type
        return self

    def tab_content(self, tab_content: ChatTabContent) -> "ChatTabBuilder":
        self._chat_tab.tab_content = tab_content
        return self

    def tab_config(self, tab_config: ChatTabConfig) -> "ChatTabBuilder":
        self._chat_tab.tab_config = tab_config
        return self

    def build(self) -> "ChatTab":
        return self._chat_tab
