# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class ChatTabContent(object):
    _types = {
        "url": str,
        "doc": str,
        "meeting_minute": str,
    }

    def __init__(self, d=None):
        self.url: Optional[str] = None
        self.doc: Optional[str] = None
        self.meeting_minute: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ChatTabContentBuilder":
        return ChatTabContentBuilder()


class ChatTabContentBuilder(object):
    def __init__(self) -> None:
        self._chat_tab_content = ChatTabContent()

    def url(self, url: str) -> "ChatTabContentBuilder":
        self._chat_tab_content.url = url
        return self

    def doc(self, doc: str) -> "ChatTabContentBuilder":
        self._chat_tab_content.doc = doc
        return self

    def meeting_minute(self, meeting_minute: str) -> "ChatTabContentBuilder":
        self._chat_tab_content.meeting_minute = meeting_minute
        return self

    def build(self) -> "ChatTabContent":
        return self._chat_tab_content
