# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .i18n_names import I18nNames
from .restricted_mode_setting import RestrictedModeSetting


class CreateChatRequestBody(object):
    _types = {
        "avatar": str,
        "name": str,
        "description": str,
        "i18n_names": I18nNames,
        "owner_id": str,
        "user_id_list": List[str],
        "bot_id_list": List[str],
        "group_message_type": str,
        "chat_mode": str,
        "chat_type": str,
        "join_message_visibility": str,
        "leave_message_visibility": str,
        "membership_approval": str,
        "restricted_mode_setting": RestrictedModeSetting,
        "urgent_setting": str,
        "video_conference_setting": str,
        "edit_permission": str,
    }

    def __init__(self, d=None):
        self.avatar: Optional[str] = None
        self.name: Optional[str] = None
        self.description: Optional[str] = None
        self.i18n_names: Optional[I18nNames] = None
        self.owner_id: Optional[str] = None
        self.user_id_list: Optional[List[str]] = None
        self.bot_id_list: Optional[List[str]] = None
        self.group_message_type: Optional[str] = None
        self.chat_mode: Optional[str] = None
        self.chat_type: Optional[str] = None
        self.join_message_visibility: Optional[str] = None
        self.leave_message_visibility: Optional[str] = None
        self.membership_approval: Optional[str] = None
        self.restricted_mode_setting: Optional[RestrictedModeSetting] = None
        self.urgent_setting: Optional[str] = None
        self.video_conference_setting: Optional[str] = None
        self.edit_permission: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CreateChatRequestBodyBuilder":
        return CreateChatRequestBodyBuilder()


class CreateChatRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._create_chat_request_body = CreateChatRequestBody()

    def avatar(self, avatar: str) -> "CreateChatRequestBodyBuilder":
        self._create_chat_request_body.avatar = avatar
        return self

    def name(self, name: str) -> "CreateChatRequestBodyBuilder":
        self._create_chat_request_body.name = name
        return self

    def description(self, description: str) -> "CreateChatRequestBodyBuilder":
        self._create_chat_request_body.description = description
        return self

    def i18n_names(self, i18n_names: I18nNames) -> "CreateChatRequestBodyBuilder":
        self._create_chat_request_body.i18n_names = i18n_names
        return self

    def owner_id(self, owner_id: str) -> "CreateChatRequestBodyBuilder":
        self._create_chat_request_body.owner_id = owner_id
        return self

    def user_id_list(self, user_id_list: List[str]) -> "CreateChatRequestBodyBuilder":
        self._create_chat_request_body.user_id_list = user_id_list
        return self

    def bot_id_list(self, bot_id_list: List[str]) -> "CreateChatRequestBodyBuilder":
        self._create_chat_request_body.bot_id_list = bot_id_list
        return self

    def group_message_type(self, group_message_type: str) -> "CreateChatRequestBodyBuilder":
        self._create_chat_request_body.group_message_type = group_message_type
        return self

    def chat_mode(self, chat_mode: str) -> "CreateChatRequestBodyBuilder":
        self._create_chat_request_body.chat_mode = chat_mode
        return self

    def chat_type(self, chat_type: str) -> "CreateChatRequestBodyBuilder":
        self._create_chat_request_body.chat_type = chat_type
        return self

    def join_message_visibility(self, join_message_visibility: str) -> "CreateChatRequestBodyBuilder":
        self._create_chat_request_body.join_message_visibility = join_message_visibility
        return self

    def leave_message_visibility(self, leave_message_visibility: str) -> "CreateChatRequestBodyBuilder":
        self._create_chat_request_body.leave_message_visibility = leave_message_visibility
        return self

    def membership_approval(self, membership_approval: str) -> "CreateChatRequestBodyBuilder":
        self._create_chat_request_body.membership_approval = membership_approval
        return self

    def restricted_mode_setting(self, restricted_mode_setting: RestrictedModeSetting) -> "CreateChatRequestBodyBuilder":
        self._create_chat_request_body.restricted_mode_setting = restricted_mode_setting
        return self

    def urgent_setting(self, urgent_setting: str) -> "CreateChatRequestBodyBuilder":
        self._create_chat_request_body.urgent_setting = urgent_setting
        return self

    def video_conference_setting(self, video_conference_setting: str) -> "CreateChatRequestBodyBuilder":
        self._create_chat_request_body.video_conference_setting = video_conference_setting
        return self

    def edit_permission(self, edit_permission: str) -> "CreateChatRequestBodyBuilder":
        self._create_chat_request_body.edit_permission = edit_permission
        return self

    def build(self) -> "CreateChatRequestBody":
        return self._create_chat_request_body
