# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .create_chat_tab_request_body import CreateChatTabRequestBody


class CreateChatTabRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.chat_id: Optional[str] = None
        self.request_body: Optional[CreateChatTabRequestBody] = None

    @staticmethod
    def builder() -> "CreateChatTabRequestBuilder":
        return CreateChatTabRequestBuilder()


class CreateChatTabRequestBuilder(object):

    def __init__(self) -> None:
        create_chat_tab_request = CreateChatTabRequest()
        create_chat_tab_request.http_method = HttpMethod.POST
        create_chat_tab_request.uri = "/open-apis/im/v1/chats/:chat_id/chat_tabs"
        create_chat_tab_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._create_chat_tab_request: CreateChatTabRequest = create_chat_tab_request

    def chat_id(self, chat_id: str) -> "CreateChatTabRequestBuilder":
        self._create_chat_tab_request.chat_id = chat_id
        self._create_chat_tab_request.paths["chat_id"] = str(chat_id)
        return self

    def request_body(self, request_body: CreateChatTabRequestBody) -> "CreateChatTabRequestBuilder":
        self._create_chat_tab_request.request_body = request_body
        self._create_chat_tab_request.body = request_body
        return self

    def build(self) -> CreateChatTabRequest:
        return self._create_chat_tab_request
