# Code generated by Lark OpenAPI.

from typing import Any, Optional, IO

from lark_oapi.core.construct import init


class CreateFileRequestBody(object):
    _types = {
        "file_type": str,
        "file_name": str,
        "duration": int,
        "file": IO[Any],
    }

    def __init__(self, d=None):
        self.file_type: Optional[str] = None
        self.file_name: Optional[str] = None
        self.duration: Optional[int] = None
        self.file: Optional[IO[Any]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CreateFileRequestBodyBuilder":
        return CreateFileRequestBodyBuilder()


class CreateFileRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._create_file_request_body = CreateFileRequestBody()

    def file_type(self, file_type: str) -> "CreateFileRequestBodyBuilder":
        self._create_file_request_body.file_type = file_type
        return self

    def file_name(self, file_name: str) -> "CreateFileRequestBodyBuilder":
        self._create_file_request_body.file_name = file_name
        return self

    def duration(self, duration: int) -> "CreateFileRequestBodyBuilder":
        self._create_file_request_body.duration = duration
        return self

    def file(self, file: IO[Any]) -> "CreateFileRequestBodyBuilder":
        self._create_file_request_body.file = file
        return self

    def build(self) -> "CreateFileRequestBody":
        return self._create_file_request_body
