# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .create_image_request_body import CreateImageRequestBody


class CreateImageRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[CreateImageRequestBody] = None

    @staticmethod
    def builder() -> "CreateImageRequestBuilder":
        return CreateImageRequestBuilder()


class CreateImageRequestBuilder(object):

    def __init__(self) -> None:
        create_image_request = CreateImageRequest()
        create_image_request.http_method = HttpMethod.POST
        create_image_request.uri = "/open-apis/im/v1/images"
        create_image_request.token_types = {AccessTokenType.TENANT}
        self._create_image_request: CreateImageRequest = create_image_request

    def request_body(self, request_body: CreateImageRequestBody) -> "CreateImageRequestBuilder":
        self._create_image_request.request_body = request_body
        self._create_image_request.body = request_body
        return self

    def build(self) -> CreateImageRequest:
        return self._create_image_request
