# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .create_message_request_body import CreateMessageRequestBody


class CreateMessageRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.receive_id_type: Optional[str] = None
        self.request_body: Optional[CreateMessageRequestBody] = None

    @staticmethod
    def builder() -> "CreateMessageRequestBuilder":
        return CreateMessageRequestBuilder()


class CreateMessageRequestBuilder(object):

    def __init__(self) -> None:
        create_message_request = CreateMessageRequest()
        create_message_request.http_method = HttpMethod.POST
        create_message_request.uri = "/open-apis/im/v1/messages"
        create_message_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._create_message_request: CreateMessageRequest = create_message_request

    def receive_id_type(self, receive_id_type: str) -> "CreateMessageRequestBuilder":
        self._create_message_request.receive_id_type = receive_id_type
        self._create_message_request.add_query("receive_id_type", receive_id_type)
        return self

    def request_body(self, request_body: CreateMessageRequestBody) -> "CreateMessageRequestBuilder":
        self._create_message_request.request_body = request_body
        self._create_message_request.body = request_body
        return self

    def build(self) -> CreateMessageRequest:
        return self._create_message_request
