# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .create_pin_request_body import CreatePinRequestBody


class CreatePinRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[CreatePinRequestBody] = None

    @staticmethod
    def builder() -> "CreatePinRequestBuilder":
        return CreatePinRequestBuilder()


class CreatePinRequestBuilder(object):

    def __init__(self) -> None:
        create_pin_request = CreatePinRequest()
        create_pin_request.http_method = HttpMethod.POST
        create_pin_request.uri = "/open-apis/im/v1/pins"
        create_pin_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._create_pin_request: CreatePinRequest = create_pin_request

    def request_body(self, request_body: CreatePinRequestBody) -> "CreatePinRequestBuilder":
        self._create_pin_request.request_body = request_body
        self._create_pin_request.body = request_body
        return self

    def build(self) -> CreatePinRequest:
        return self._create_pin_request
