# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class DeleteBatchMessageRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.batch_message_id: Optional[str] = None

    @staticmethod
    def builder() -> "DeleteBatchMessageRequestBuilder":
        return DeleteBatchMessageRequestBuilder()


class DeleteBatchMessageRequestBuilder(object):

    def __init__(self) -> None:
        delete_batch_message_request = DeleteBatchMessageRequest()
        delete_batch_message_request.http_method = HttpMethod.DELETE
        delete_batch_message_request.uri = "/open-apis/im/v1/batch_messages/:batch_message_id"
        delete_batch_message_request.token_types = {AccessTokenType.TENANT}
        self._delete_batch_message_request: DeleteBatchMessageRequest = delete_batch_message_request

    def batch_message_id(self, batch_message_id: str) -> "DeleteBatchMessageRequestBuilder":
        self._delete_batch_message_request.batch_message_id = batch_message_id
        self._delete_batch_message_request.paths["batch_message_id"] = str(batch_message_id)
        return self

    def build(self) -> DeleteBatchMessageRequest:
        return self._delete_batch_message_request
