# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class DeleteChatRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.chat_id: Optional[str] = None

    @staticmethod
    def builder() -> "DeleteChatRequestBuilder":
        return DeleteChatRequestBuilder()


class DeleteChatRequestBuilder(object):

    def __init__(self) -> None:
        delete_chat_request = DeleteChatRequest()
        delete_chat_request.http_method = HttpMethod.DELETE
        delete_chat_request.uri = "/open-apis/im/v1/chats/:chat_id"
        delete_chat_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._delete_chat_request: DeleteChatRequest = delete_chat_request

    def chat_id(self, chat_id: str) -> "DeleteChatRequestBuilder":
        self._delete_chat_request.chat_id = chat_id
        self._delete_chat_request.paths["chat_id"] = str(chat_id)
        return self

    def build(self) -> DeleteChatRequest:
        return self._delete_chat_request
