# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .emoji import Emoji
from .operator import Operator


class DeleteMessageReactionResponseBody(object):
    _types = {
        "reaction_id": str,
        "operator": Operator,
        "action_time": int,
        "reaction_type": Emoji,
    }

    def __init__(self, d=None):
        self.reaction_id: Optional[str] = None
        self.operator: Optional[Operator] = None
        self.action_time: Optional[int] = None
        self.reaction_type: Optional[Emoji] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "DeleteMessageReactionResponseBodyBuilder":
        return DeleteMessageReactionResponseBodyBuilder()


class DeleteMessageReactionResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._delete_message_reaction_response_body = DeleteMessageReactionResponseBody()

    def reaction_id(self, reaction_id: str) -> "DeleteMessageReactionResponseBodyBuilder":
        self._delete_message_reaction_response_body.reaction_id = reaction_id
        return self

    def operator(self, operator: Operator) -> "DeleteMessageReactionResponseBodyBuilder":
        self._delete_message_reaction_response_body.operator = operator
        return self

    def action_time(self, action_time: int) -> "DeleteMessageReactionResponseBodyBuilder":
        self._delete_message_reaction_response_body.action_time = action_time
        return self

    def reaction_type(self, reaction_type: Emoji) -> "DeleteMessageReactionResponseBodyBuilder":
        self._delete_message_reaction_response_body.reaction_type = reaction_type
        return self

    def build(self) -> "DeleteMessageReactionResponseBody":
        return self._delete_message_reaction_response_body
