# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class DeleteMessageRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.message_id: Optional[str] = None

    @staticmethod
    def builder() -> "DeleteMessageRequestBuilder":
        return DeleteMessageRequestBuilder()


class DeleteMessageRequestBuilder(object):

    def __init__(self) -> None:
        delete_message_request = DeleteMessageRequest()
        delete_message_request.http_method = HttpMethod.DELETE
        delete_message_request.uri = "/open-apis/im/v1/messages/:message_id"
        delete_message_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._delete_message_request: DeleteMessageRequest = delete_message_request

    def message_id(self, message_id: str) -> "DeleteMessageRequestBuilder":
        self._delete_message_request.message_id = message_id
        self._delete_message_request.paths["message_id"] = str(message_id)
        return self

    def build(self) -> DeleteMessageRequest:
        return self._delete_message_request
