# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .delete_tabs_chat_tab_request_body import DeleteTabsChatTabRequestBody


class DeleteTabsChatTabRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.chat_id: Optional[str] = None
        self.request_body: Optional[DeleteTabsChatTabRequestBody] = None

    @staticmethod
    def builder() -> "DeleteTabsChatTabRequestBuilder":
        return DeleteTabsChatTabRequestBuilder()


class DeleteTabsChatTabRequestBuilder(object):

    def __init__(self) -> None:
        delete_tabs_chat_tab_request = DeleteTabsChatTabRequest()
        delete_tabs_chat_tab_request.http_method = HttpMethod.DELETE
        delete_tabs_chat_tab_request.uri = "/open-apis/im/v1/chats/:chat_id/chat_tabs/delete_tabs"
        delete_tabs_chat_tab_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._delete_tabs_chat_tab_request: DeleteTabsChatTabRequest = delete_tabs_chat_tab_request

    def chat_id(self, chat_id: str) -> "DeleteTabsChatTabRequestBuilder":
        self._delete_tabs_chat_tab_request.chat_id = chat_id
        self._delete_tabs_chat_tab_request.paths["chat_id"] = str(chat_id)
        return self

    def request_body(self, request_body: DeleteTabsChatTabRequestBody) -> "DeleteTabsChatTabRequestBuilder":
        self._delete_tabs_chat_tab_request.request_body = request_body
        self._delete_tabs_chat_tab_request.body = request_body
        return self

    def build(self) -> DeleteTabsChatTabRequest:
        return self._delete_tabs_chat_tab_request
