# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .user_id import UserId


class EventMessageReader(object):
    _types = {
        "reader_id": UserId,
        "read_time": str,
        "tenant_key": str,
    }

    def __init__(self, d=None):
        self.reader_id: Optional[UserId] = None
        self.read_time: Optional[str] = None
        self.tenant_key: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "EventMessageReaderBuilder":
        return EventMessageReaderBuilder()


class EventMessageReaderBuilder(object):
    def __init__(self) -> None:
        self._event_message_reader = EventMessageReader()

    def reader_id(self, reader_id: UserId) -> "EventMessageReaderBuilder":
        self._event_message_reader.reader_id = reader_id
        return self

    def read_time(self, read_time: str) -> "EventMessageReaderBuilder":
        self._event_message_reader.read_time = read_time
        return self

    def tenant_key(self, tenant_key: str) -> "EventMessageReaderBuilder":
        self._event_message_reader.tenant_key = tenant_key
        return self

    def build(self) -> "EventMessageReader":
        return self._event_message_reader
