# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetChatMembersRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.member_id_type: Optional[str] = None
        self.page_size: Optional[int] = None
        self.page_token: Optional[str] = None
        self.chat_id: Optional[str] = None

    @staticmethod
    def builder() -> "GetChatMembersRequestBuilder":
        return GetChatMembersRequestBuilder()


class GetChatMembersRequestBuilder(object):

    def __init__(self) -> None:
        get_chat_members_request = GetChatMembersRequest()
        get_chat_members_request.http_method = HttpMethod.GET
        get_chat_members_request.uri = "/open-apis/im/v1/chats/:chat_id/members"
        get_chat_members_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._get_chat_members_request: GetChatMembersRequest = get_chat_members_request

    def member_id_type(self, member_id_type: str) -> "GetChatMembersRequestBuilder":
        self._get_chat_members_request.member_id_type = member_id_type
        self._get_chat_members_request.add_query("member_id_type", member_id_type)
        return self

    def page_size(self, page_size: int) -> "GetChatMembersRequestBuilder":
        self._get_chat_members_request.page_size = page_size
        self._get_chat_members_request.add_query("page_size", page_size)
        return self

    def page_token(self, page_token: str) -> "GetChatMembersRequestBuilder":
        self._get_chat_members_request.page_token = page_token
        self._get_chat_members_request.add_query("page_token", page_token)
        return self

    def chat_id(self, chat_id: str) -> "GetChatMembersRequestBuilder":
        self._get_chat_members_request.chat_id = chat_id
        self._get_chat_members_request.paths["chat_id"] = str(chat_id)
        return self

    def build(self) -> GetChatMembersRequest:
        return self._get_chat_members_request
