# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .list_member import ListMember


class GetChatMembersResponseBody(object):
    _types = {
        "items": List[ListMember],
        "page_token": str,
        "has_more": bool,
        "member_total": int,
    }

    def __init__(self, d=None):
        self.items: Optional[List[ListMember]] = None
        self.page_token: Optional[str] = None
        self.has_more: Optional[bool] = None
        self.member_total: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "GetChatMembersResponseBodyBuilder":
        return GetChatMembersResponseBodyBuilder()


class GetChatMembersResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._get_chat_members_response_body = GetChatMembersResponseBody()

    def items(self, items: List[ListMember]) -> "GetChatMembersResponseBodyBuilder":
        self._get_chat_members_response_body.items = items
        return self

    def page_token(self, page_token: str) -> "GetChatMembersResponseBodyBuilder":
        self._get_chat_members_response_body.page_token = page_token
        return self

    def has_more(self, has_more: bool) -> "GetChatMembersResponseBodyBuilder":
        self._get_chat_members_response_body.has_more = has_more
        return self

    def member_total(self, member_total: int) -> "GetChatMembersResponseBodyBuilder":
        self._get_chat_members_response_body.member_total = member_total
        return self

    def build(self) -> "GetChatMembersResponseBody":
        return self._get_chat_members_response_body
