# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetFileRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.file_key: Optional[str] = None

    @staticmethod
    def builder() -> "GetFileRequestBuilder":
        return GetFileRequestBuilder()


class GetFileRequestBuilder(object):

    def __init__(self) -> None:
        get_file_request = GetFileRequest()
        get_file_request.http_method = HttpMethod.GET
        get_file_request.uri = "/open-apis/im/v1/files/:file_key"
        get_file_request.token_types = {AccessTokenType.TENANT}
        self._get_file_request: GetFileRequest = get_file_request

    def file_key(self, file_key: str) -> "GetFileRequestBuilder":
        self._get_file_request.file_key = file_key
        self._get_file_request.paths["file_key"] = str(file_key)
        return self

    def build(self) -> GetFileRequest:
        return self._get_file_request
