# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetImageRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.image_key: Optional[str] = None

    @staticmethod
    def builder() -> "GetImageRequestBuilder":
        return GetImageRequestBuilder()


class GetImageRequestBuilder(object):

    def __init__(self) -> None:
        get_image_request = GetImageRequest()
        get_image_request.http_method = HttpMethod.GET
        get_image_request.uri = "/open-apis/im/v1/images/:image_key"
        get_image_request.token_types = {AccessTokenType.TENANT}
        self._get_image_request: GetImageRequest = get_image_request

    def image_key(self, image_key: str) -> "GetImageRequestBuilder":
        self._get_image_request.image_key = image_key
        self._get_image_request.paths["image_key"] = str(image_key)
        return self

    def build(self) -> GetImageRequest:
        return self._get_image_request
