# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetMessageRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.message_id: Optional[str] = None

    @staticmethod
    def builder() -> "GetMessageRequestBuilder":
        return GetMessageRequestBuilder()


class GetMessageRequestBuilder(object):

    def __init__(self) -> None:
        get_message_request = GetMessageRequest()
        get_message_request.http_method = HttpMethod.GET
        get_message_request.uri = "/open-apis/im/v1/messages/:message_id"
        get_message_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._get_message_request: GetMessageRequest = get_message_request

    def user_id_type(self, user_id_type: str) -> "GetMessageRequestBuilder":
        self._get_message_request.user_id_type = user_id_type
        self._get_message_request.add_query("user_id_type", user_id_type)
        return self

    def message_id(self, message_id: str) -> "GetMessageRequestBuilder":
        self._get_message_request.message_id = message_id
        self._get_message_request.paths["message_id"] = str(message_id)
        return self

    def build(self) -> GetMessageRequest:
        return self._get_message_request
