# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetMessageResourceRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.type: Optional[str] = None
        self.message_id: Optional[str] = None
        self.file_key: Optional[str] = None

    @staticmethod
    def builder() -> "GetMessageResourceRequestBuilder":
        return GetMessageResourceRequestBuilder()


class GetMessageResourceRequestBuilder(object):

    def __init__(self) -> None:
        get_message_resource_request = GetMessageResourceRequest()
        get_message_resource_request.http_method = HttpMethod.GET
        get_message_resource_request.uri = "/open-apis/im/v1/messages/:message_id/resources/:file_key"
        get_message_resource_request.token_types = {AccessTokenType.TENANT}
        self._get_message_resource_request: GetMessageResourceRequest = get_message_resource_request

    def type(self, type: str) -> "GetMessageResourceRequestBuilder":
        self._get_message_resource_request.type = type
        self._get_message_resource_request.add_query("type", type)
        return self

    def message_id(self, message_id: str) -> "GetMessageResourceRequestBuilder":
        self._get_message_resource_request.message_id = message_id
        self._get_message_resource_request.paths["message_id"] = str(message_id)
        return self

    def file_key(self, file_key: str) -> "GetMessageResourceRequestBuilder":
        self._get_message_resource_request.file_key = file_key
        self._get_message_resource_request.paths["file_key"] = str(file_key)
        return self

    def build(self) -> GetMessageResourceRequest:
        return self._get_message_resource_request
