# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class IsInChatChatMembersRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.chat_id: Optional[str] = None

    @staticmethod
    def builder() -> "IsInChatChatMembersRequestBuilder":
        return IsInChatChatMembersRequestBuilder()


class IsInChatChatMembersRequestBuilder(object):

    def __init__(self) -> None:
        is_in_chat_chat_members_request = IsInChatChatMembersRequest()
        is_in_chat_chat_members_request.http_method = HttpMethod.GET
        is_in_chat_chat_members_request.uri = "/open-apis/im/v1/chats/:chat_id/members/is_in_chat"
        is_in_chat_chat_members_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._is_in_chat_chat_members_request: IsInChatChatMembersRequest = is_in_chat_chat_members_request

    def chat_id(self, chat_id: str) -> "IsInChatChatMembersRequestBuilder":
        self._is_in_chat_chat_members_request.chat_id = chat_id
        self._is_in_chat_chat_members_request.paths["chat_id"] = str(chat_id)
        return self

    def build(self) -> IsInChatChatMembersRequest:
        return self._is_in_chat_chat_members_request
