# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .link_chat_request_body import LinkChatRequestBody


class LinkChatRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.chat_id: Optional[str] = None
        self.request_body: Optional[LinkChatRequestBody] = None

    @staticmethod
    def builder() -> "LinkChatRequestBuilder":
        return LinkChatRequestBuilder()


class LinkChatRequestBuilder(object):

    def __init__(self) -> None:
        link_chat_request = LinkChatRequest()
        link_chat_request.http_method = HttpMethod.POST
        link_chat_request.uri = "/open-apis/im/v1/chats/:chat_id/link"
        link_chat_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._link_chat_request: LinkChatRequest = link_chat_request

    def chat_id(self, chat_id: str) -> "LinkChatRequestBuilder":
        self._link_chat_request.chat_id = chat_id
        self._link_chat_request.paths["chat_id"] = str(chat_id)
        return self

    def request_body(self, request_body: LinkChatRequestBody) -> "LinkChatRequestBuilder":
        self._link_chat_request.request_body = request_body
        self._link_chat_request.body = request_body
        return self

    def build(self) -> LinkChatRequest:
        return self._link_chat_request
