# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class LinkChatResponseBody(object):
    _types = {
        "share_link": str,
        "expire_time": str,
        "is_permanent": bool,
    }

    def __init__(self, d=None):
        self.share_link: Optional[str] = None
        self.expire_time: Optional[str] = None
        self.is_permanent: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "LinkChatResponseBodyBuilder":
        return LinkChatResponseBodyBuilder()


class LinkChatResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._link_chat_response_body = LinkChatResponseBody()

    def share_link(self, share_link: str) -> "LinkChatResponseBodyBuilder":
        self._link_chat_response_body.share_link = share_link
        return self

    def expire_time(self, expire_time: str) -> "LinkChatResponseBodyBuilder":
        self._link_chat_response_body.expire_time = expire_time
        return self

    def is_permanent(self, is_permanent: bool) -> "LinkChatResponseBodyBuilder":
        self._link_chat_response_body.is_permanent = is_permanent
        return self

    def build(self) -> "LinkChatResponseBody":
        return self._link_chat_response_body
