# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class ListChat(object):
    _types = {
        "chat_id": str,
        "avatar": str,
        "name": str,
        "description": str,
        "owner_id": str,
        "owner_id_type": str,
        "external": bool,
        "tenant_key": str,
    }

    def __init__(self, d=None):
        self.chat_id: Optional[str] = None
        self.avatar: Optional[str] = None
        self.name: Optional[str] = None
        self.description: Optional[str] = None
        self.owner_id: Optional[str] = None
        self.owner_id_type: Optional[str] = None
        self.external: Optional[bool] = None
        self.tenant_key: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListChatBuilder":
        return ListChatBuilder()


class ListChatBuilder(object):
    def __init__(self) -> None:
        self._list_chat = ListChat()

    def chat_id(self, chat_id: str) -> "ListChatBuilder":
        self._list_chat.chat_id = chat_id
        return self

    def avatar(self, avatar: str) -> "ListChatBuilder":
        self._list_chat.avatar = avatar
        return self

    def name(self, name: str) -> "ListChatBuilder":
        self._list_chat.name = name
        return self

    def description(self, description: str) -> "ListChatBuilder":
        self._list_chat.description = description
        return self

    def owner_id(self, owner_id: str) -> "ListChatBuilder":
        self._list_chat.owner_id = owner_id
        return self

    def owner_id_type(self, owner_id_type: str) -> "ListChatBuilder":
        self._list_chat.owner_id_type = owner_id_type
        return self

    def external(self, external: bool) -> "ListChatBuilder":
        self._list_chat.external = external
        return self

    def tenant_key(self, tenant_key: str) -> "ListChatBuilder":
        self._list_chat.tenant_key = tenant_key
        return self

    def build(self) -> "ListChat":
        return self._list_chat
