# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .message_reaction import MessageReaction


class ListMessageReactionResponseBody(object):
    _types = {
        "items": List[MessageReaction],
        "has_more": bool,
        "page_token": str,
    }

    def __init__(self, d=None):
        self.items: Optional[List[MessageReaction]] = None
        self.has_more: Optional[bool] = None
        self.page_token: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListMessageReactionResponseBodyBuilder":
        return ListMessageReactionResponseBodyBuilder()


class ListMessageReactionResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_message_reaction_response_body = ListMessageReactionResponseBody()

    def items(self, items: List[MessageReaction]) -> "ListMessageReactionResponseBodyBuilder":
        self._list_message_reaction_response_body.items = items
        return self

    def has_more(self, has_more: bool) -> "ListMessageReactionResponseBodyBuilder":
        self._list_message_reaction_response_body.has_more = has_more
        return self

    def page_token(self, page_token: str) -> "ListMessageReactionResponseBodyBuilder":
        self._list_message_reaction_response_body.page_token = page_token
        return self

    def build(self) -> "ListMessageReactionResponseBody":
        return self._list_message_reaction_response_body
