# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListMessageRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.container_id_type: Optional[str] = None
        self.container_id: Optional[str] = None
        self.start_time: Optional[str] = None
        self.end_time: Optional[str] = None
        self.sort_type: Optional[str] = None
        self.page_size: Optional[int] = None
        self.page_token: Optional[str] = None

    @staticmethod
    def builder() -> "ListMessageRequestBuilder":
        return ListMessageRequestBuilder()


class ListMessageRequestBuilder(object):

    def __init__(self) -> None:
        list_message_request = ListMessageRequest()
        list_message_request.http_method = HttpMethod.GET
        list_message_request.uri = "/open-apis/im/v1/messages"
        list_message_request.token_types = {AccessTokenType.TENANT}
        self._list_message_request: ListMessageRequest = list_message_request

    def container_id_type(self, container_id_type: str) -> "ListMessageRequestBuilder":
        self._list_message_request.container_id_type = container_id_type
        self._list_message_request.add_query("container_id_type", container_id_type)
        return self

    def container_id(self, container_id: str) -> "ListMessageRequestBuilder":
        self._list_message_request.container_id = container_id
        self._list_message_request.add_query("container_id", container_id)
        return self

    def start_time(self, start_time: str) -> "ListMessageRequestBuilder":
        self._list_message_request.start_time = start_time
        self._list_message_request.add_query("start_time", start_time)
        return self

    def end_time(self, end_time: str) -> "ListMessageRequestBuilder":
        self._list_message_request.end_time = end_time
        self._list_message_request.add_query("end_time", end_time)
        return self

    def sort_type(self, sort_type: str) -> "ListMessageRequestBuilder":
        self._list_message_request.sort_type = sort_type
        self._list_message_request.add_query("sort_type", sort_type)
        return self

    def page_size(self, page_size: int) -> "ListMessageRequestBuilder":
        self._list_message_request.page_size = page_size
        self._list_message_request.add_query("page_size", page_size)
        return self

    def page_token(self, page_token: str) -> "ListMessageRequestBuilder":
        self._list_message_request.page_token = page_token
        self._list_message_request.add_query("page_token", page_token)
        return self

    def build(self) -> ListMessageRequest:
        return self._list_message_request
