# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListPinRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.chat_id: Optional[str] = None
        self.start_time: Optional[str] = None
        self.end_time: Optional[str] = None
        self.page_size: Optional[int] = None
        self.page_token: Optional[str] = None

    @staticmethod
    def builder() -> "ListPinRequestBuilder":
        return ListPinRequestBuilder()


class ListPinRequestBuilder(object):

    def __init__(self) -> None:
        list_pin_request = ListPinRequest()
        list_pin_request.http_method = HttpMethod.GET
        list_pin_request.uri = "/open-apis/im/v1/pins"
        list_pin_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._list_pin_request: ListPinRequest = list_pin_request

    def chat_id(self, chat_id: str) -> "ListPinRequestBuilder":
        self._list_pin_request.chat_id = chat_id
        self._list_pin_request.add_query("chat_id", chat_id)
        return self

    def start_time(self, start_time: str) -> "ListPinRequestBuilder":
        self._list_pin_request.start_time = start_time
        self._list_pin_request.add_query("start_time", start_time)
        return self

    def end_time(self, end_time: str) -> "ListPinRequestBuilder":
        self._list_pin_request.end_time = end_time
        self._list_pin_request.add_query("end_time", end_time)
        return self

    def page_size(self, page_size: int) -> "ListPinRequestBuilder":
        self._list_pin_request.page_size = page_size
        self._list_pin_request.add_query("page_size", page_size)
        return self

    def page_token(self, page_token: str) -> "ListPinRequestBuilder":
        self._list_pin_request.page_token = page_token
        self._list_pin_request.add_query("page_token", page_token)
        return self

    def build(self) -> ListPinRequest:
        return self._list_pin_request
