# Code generated by Lark OpenAPI.

from typing import *

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListSpecialFocusRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.member_id_type: Optional[str] = None
        self.page_size: Optional[int] = None
        self.page_token: Optional[str] = None

    @staticmethod
    def builder() -> "ListSpecialFocusRequestBuilder":
        return ListSpecialFocusRequestBuilder()


class ListSpecialFocusRequestBuilder(object):

    def __init__(self) -> None:
        list_special_focus_request = ListSpecialFocusRequest()
        list_special_focus_request.http_method = HttpMethod.GET
        list_special_focus_request.uri = "/open-apis/im/v1/special_focus"
        list_special_focus_request.token_types = {AccessTokenType.USER}
        self._list_special_focus_request: ListSpecialFocusRequest = list_special_focus_request

    def member_id_type(self, member_id_type: str) -> "ListSpecialFocusRequestBuilder":
        self._list_special_focus_request.member_id_type = member_id_type
        self._list_special_focus_request.add_query("member_id_type", member_id_type)
        return self

    def page_size(self, page_size: int) -> "ListSpecialFocusRequestBuilder":
        self._list_special_focus_request.page_size = page_size
        self._list_special_focus_request.add_query("page_size", page_size)
        return self

    def page_token(self, page_token: str) -> "ListSpecialFocusRequestBuilder":
        self._list_special_focus_request.page_token = page_token
        self._list_special_focus_request.add_query("page_token", page_token)
        return self

    def build(self) -> ListSpecialFocusRequest:
        return self._list_special_focus_request
