# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .emoji import Emoji
from .operator import Operator


class MessageReaction(object):
    _types = {
        "reaction_id": str,
        "operator": Operator,
        "action_time": int,
        "reaction_type": Emoji,
    }

    def __init__(self, d=None):
        self.reaction_id: Optional[str] = None
        self.operator: Optional[Operator] = None
        self.action_time: Optional[int] = None
        self.reaction_type: Optional[Emoji] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "MessageReactionBuilder":
        return MessageReactionBuilder()


class MessageReactionBuilder(object):
    def __init__(self) -> None:
        self._message_reaction = MessageReaction()

    def reaction_id(self, reaction_id: str) -> "MessageReactionBuilder":
        self._message_reaction.reaction_id = reaction_id
        return self

    def operator(self, operator: Operator) -> "MessageReactionBuilder":
        self._message_reaction.operator = operator
        return self

    def action_time(self, action_time: int) -> "MessageReactionBuilder":
        self._message_reaction.action_time = action_time
        return self

    def reaction_type(self, reaction_type: Emoji) -> "MessageReactionBuilder":
        self._message_reaction.reaction_type = reaction_type
        return self

    def build(self) -> "MessageReaction":
        return self._message_reaction
