# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .list_event_moderator import ListEventModerator


class ModeratorList(object):
    _types = {
        "added_member_list": List[ListEventModerator],
        "removed_member_list": List[ListEventModerator],
    }

    def __init__(self, d=None):
        self.added_member_list: Optional[List[ListEventModerator]] = None
        self.removed_member_list: Optional[List[ListEventModerator]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ModeratorListBuilder":
        return ModeratorListBuilder()


class ModeratorListBuilder(object):
    def __init__(self) -> None:
        self._moderator_list = ModeratorList()

    def added_member_list(self, added_member_list: List[ListEventModerator]) -> "ModeratorListBuilder":
        self._moderator_list.added_member_list = added_member_list
        return self

    def removed_member_list(self, removed_member_list: List[ListEventModerator]) -> "ModeratorListBuilder":
        self._moderator_list.removed_member_list = removed_member_list
        return self

    def build(self) -> "ModeratorList":
        return self._moderator_list
