# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class MsgProcessData(object):
    _types = {
        "p_date": str,
        "department_id": str,
        "department_path": str,
        "avg_imp_msg_read_rate_12h": float,
        "msg_read_rate_12h": float,
        "avg_receive_msg_cnt": float,
        "avg_read_msg_cnt": float,
        "avg_imp_read_msg_cnt": float,
        "avg_imp_receive_msg_cnt": float,
        "high_load_rate": float,
        "big_group_msg_rate": float,
        "big_group_topic_msg_rate": float,
        "avg_receive_bot_msg_cnt": float,
        "avg_bot_imp_msg_read_rate_12h": float,
        "receive_bot_msg_rate": float,
        "use_chat_box_rate": float,
        "receive_mute_msg_rate": float,
        "read_mute_msg_rate": float,
        "avg_receive_imp_msg_chat_cnt": float,
    }

    def __init__(self, d=None):
        self.p_date: Optional[str] = None
        self.department_id: Optional[str] = None
        self.department_path: Optional[str] = None
        self.avg_imp_msg_read_rate_12h: Optional[float] = None
        self.msg_read_rate_12h: Optional[float] = None
        self.avg_receive_msg_cnt: Optional[float] = None
        self.avg_read_msg_cnt: Optional[float] = None
        self.avg_imp_read_msg_cnt: Optional[float] = None
        self.avg_imp_receive_msg_cnt: Optional[float] = None
        self.high_load_rate: Optional[float] = None
        self.big_group_msg_rate: Optional[float] = None
        self.big_group_topic_msg_rate: Optional[float] = None
        self.avg_receive_bot_msg_cnt: Optional[float] = None
        self.avg_bot_imp_msg_read_rate_12h: Optional[float] = None
        self.receive_bot_msg_rate: Optional[float] = None
        self.use_chat_box_rate: Optional[float] = None
        self.receive_mute_msg_rate: Optional[float] = None
        self.read_mute_msg_rate: Optional[float] = None
        self.avg_receive_imp_msg_chat_cnt: Optional[float] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "MsgProcessDataBuilder":
        return MsgProcessDataBuilder()


class MsgProcessDataBuilder(object):
    def __init__(self) -> None:
        self._msg_process_data = MsgProcessData()

    def p_date(self, p_date: str) -> "MsgProcessDataBuilder":
        self._msg_process_data.p_date = p_date
        return self

    def department_id(self, department_id: str) -> "MsgProcessDataBuilder":
        self._msg_process_data.department_id = department_id
        return self

    def department_path(self, department_path: str) -> "MsgProcessDataBuilder":
        self._msg_process_data.department_path = department_path
        return self

    def avg_imp_msg_read_rate_12h(self, avg_imp_msg_read_rate_12h: float) -> "MsgProcessDataBuilder":
        self._msg_process_data.avg_imp_msg_read_rate_12h = avg_imp_msg_read_rate_12h
        return self

    def msg_read_rate_12h(self, msg_read_rate_12h: float) -> "MsgProcessDataBuilder":
        self._msg_process_data.msg_read_rate_12h = msg_read_rate_12h
        return self

    def avg_receive_msg_cnt(self, avg_receive_msg_cnt: float) -> "MsgProcessDataBuilder":
        self._msg_process_data.avg_receive_msg_cnt = avg_receive_msg_cnt
        return self

    def avg_read_msg_cnt(self, avg_read_msg_cnt: float) -> "MsgProcessDataBuilder":
        self._msg_process_data.avg_read_msg_cnt = avg_read_msg_cnt
        return self

    def avg_imp_read_msg_cnt(self, avg_imp_read_msg_cnt: float) -> "MsgProcessDataBuilder":
        self._msg_process_data.avg_imp_read_msg_cnt = avg_imp_read_msg_cnt
        return self

    def avg_imp_receive_msg_cnt(self, avg_imp_receive_msg_cnt: float) -> "MsgProcessDataBuilder":
        self._msg_process_data.avg_imp_receive_msg_cnt = avg_imp_receive_msg_cnt
        return self

    def high_load_rate(self, high_load_rate: float) -> "MsgProcessDataBuilder":
        self._msg_process_data.high_load_rate = high_load_rate
        return self

    def big_group_msg_rate(self, big_group_msg_rate: float) -> "MsgProcessDataBuilder":
        self._msg_process_data.big_group_msg_rate = big_group_msg_rate
        return self

    def big_group_topic_msg_rate(self, big_group_topic_msg_rate: float) -> "MsgProcessDataBuilder":
        self._msg_process_data.big_group_topic_msg_rate = big_group_topic_msg_rate
        return self

    def avg_receive_bot_msg_cnt(self, avg_receive_bot_msg_cnt: float) -> "MsgProcessDataBuilder":
        self._msg_process_data.avg_receive_bot_msg_cnt = avg_receive_bot_msg_cnt
        return self

    def avg_bot_imp_msg_read_rate_12h(self, avg_bot_imp_msg_read_rate_12h: float) -> "MsgProcessDataBuilder":
        self._msg_process_data.avg_bot_imp_msg_read_rate_12h = avg_bot_imp_msg_read_rate_12h
        return self

    def receive_bot_msg_rate(self, receive_bot_msg_rate: float) -> "MsgProcessDataBuilder":
        self._msg_process_data.receive_bot_msg_rate = receive_bot_msg_rate
        return self

    def use_chat_box_rate(self, use_chat_box_rate: float) -> "MsgProcessDataBuilder":
        self._msg_process_data.use_chat_box_rate = use_chat_box_rate
        return self

    def receive_mute_msg_rate(self, receive_mute_msg_rate: float) -> "MsgProcessDataBuilder":
        self._msg_process_data.receive_mute_msg_rate = receive_mute_msg_rate
        return self

    def read_mute_msg_rate(self, read_mute_msg_rate: float) -> "MsgProcessDataBuilder":
        self._msg_process_data.read_mute_msg_rate = read_mute_msg_rate
        return self

    def avg_receive_imp_msg_chat_cnt(self, avg_receive_imp_msg_chat_cnt: float) -> "MsgProcessDataBuilder":
        self._msg_process_data.avg_receive_imp_msg_chat_cnt = avg_receive_imp_msg_chat_cnt
        return self

    def build(self) -> "MsgProcessData":
        return self._msg_process_data
