# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .patch_chat_announcement_request_body import PatchChatAnnouncementRequestBody


class PatchChatAnnouncementRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.chat_id: Optional[str] = None
        self.request_body: Optional[PatchChatAnnouncementRequestBody] = None

    @staticmethod
    def builder() -> "PatchChatAnnouncementRequestBuilder":
        return PatchChatAnnouncementRequestBuilder()


class PatchChatAnnouncementRequestBuilder(object):

    def __init__(self) -> None:
        patch_chat_announcement_request = PatchChatAnnouncementRequest()
        patch_chat_announcement_request.http_method = HttpMethod.PATCH
        patch_chat_announcement_request.uri = "/open-apis/im/v1/chats/:chat_id/announcement"
        patch_chat_announcement_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._patch_chat_announcement_request: PatchChatAnnouncementRequest = patch_chat_announcement_request

    def chat_id(self, chat_id: str) -> "PatchChatAnnouncementRequestBuilder":
        self._patch_chat_announcement_request.chat_id = chat_id
        self._patch_chat_announcement_request.paths["chat_id"] = str(chat_id)
        return self

    def request_body(self, request_body: PatchChatAnnouncementRequestBody) -> "PatchChatAnnouncementRequestBuilder":
        self._patch_chat_announcement_request.request_body = request_body
        self._patch_chat_announcement_request.body = request_body
        return self

    def build(self) -> PatchChatAnnouncementRequest:
        return self._patch_chat_announcement_request
