# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .patch_chat_menu_item_request_body import PatchChatMenuItemRequestBody


class PatchChatMenuItemRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.chat_id: Optional[str] = None
        self.menu_item_id: Optional[int] = None
        self.request_body: Optional[PatchChatMenuItemRequestBody] = None

    @staticmethod
    def builder() -> "PatchChatMenuItemRequestBuilder":
        return PatchChatMenuItemRequestBuilder()


class PatchChatMenuItemRequestBuilder(object):

    def __init__(self) -> None:
        patch_chat_menu_item_request = PatchChatMenuItemRequest()
        patch_chat_menu_item_request.http_method = HttpMethod.PATCH
        patch_chat_menu_item_request.uri = "/open-apis/im/v1/chats/:chat_id/menu_items/:menu_item_id"
        patch_chat_menu_item_request.token_types = {AccessTokenType.TENANT}
        self._patch_chat_menu_item_request: PatchChatMenuItemRequest = patch_chat_menu_item_request

    def chat_id(self, chat_id: str) -> "PatchChatMenuItemRequestBuilder":
        self._patch_chat_menu_item_request.chat_id = chat_id
        self._patch_chat_menu_item_request.paths["chat_id"] = str(chat_id)
        return self

    def menu_item_id(self, menu_item_id: int) -> "PatchChatMenuItemRequestBuilder":
        self._patch_chat_menu_item_request.menu_item_id = menu_item_id
        self._patch_chat_menu_item_request.paths["menu_item_id"] = str(menu_item_id)
        return self

    def request_body(self, request_body: PatchChatMenuItemRequestBody) -> "PatchChatMenuItemRequestBuilder":
        self._patch_chat_menu_item_request.request_body = request_body
        self._patch_chat_menu_item_request.body = request_body
        return self

    def build(self) -> PatchChatMenuItemRequest:
        return self._patch_chat_menu_item_request
