# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .chat_menu_item import ChatMenuItem


class PatchChatMenuItemRequestBody(object):
    _types = {
        "update_fields": List[str],
        "chat_menu_item": ChatMenuItem,
    }

    def __init__(self, d=None):
        self.update_fields: Optional[List[str]] = None
        self.chat_menu_item: Optional[ChatMenuItem] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "PatchChatMenuItemRequestBodyBuilder":
        return PatchChatMenuItemRequestBodyBuilder()


class PatchChatMenuItemRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._patch_chat_menu_item_request_body = PatchChatMenuItemRequestBody()

    def update_fields(self, update_fields: List[str]) -> "PatchChatMenuItemRequestBodyBuilder":
        self._patch_chat_menu_item_request_body.update_fields = update_fields
        return self

    def chat_menu_item(self, chat_menu_item: ChatMenuItem) -> "PatchChatMenuItemRequestBodyBuilder":
        self._patch_chat_menu_item_request_body.chat_menu_item = chat_menu_item
        return self

    def build(self) -> "PatchChatMenuItemRequestBody":
        return self._patch_chat_menu_item_request_body
