# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .message import Message
from .pin import Pin


class PinedMessage(object):
    _types = {
        "pin": Pin,
        "message": Message,
    }

    def __init__(self, d=None):
        self.pin: Optional[Pin] = None
        self.message: Optional[Message] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "PinedMessageBuilder":
        return PinedMessageBuilder()


class PinedMessageBuilder(object):
    def __init__(self) -> None:
        self._pined_message = PinedMessage()

    def pin(self, pin: Pin) -> "PinedMessageBuilder":
        self._pined_message.pin = pin
        return self

    def message(self, message: Message) -> "PinedMessageBuilder":
        self._pined_message.message = message
        return self

    def build(self) -> "PinedMessage":
        return self._pined_message
