# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .put_top_notice_chat_top_notice_request_body import PutTopNoticeChatTopNoticeRequestBody


class PutTopNoticeChatTopNoticeRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.chat_id: Optional[str] = None
        self.request_body: Optional[PutTopNoticeChatTopNoticeRequestBody] = None

    @staticmethod
    def builder() -> "PutTopNoticeChatTopNoticeRequestBuilder":
        return PutTopNoticeChatTopNoticeRequestBuilder()


class PutTopNoticeChatTopNoticeRequestBuilder(object):

    def __init__(self) -> None:
        put_top_notice_chat_top_notice_request = PutTopNoticeChatTopNoticeRequest()
        put_top_notice_chat_top_notice_request.http_method = HttpMethod.POST
        put_top_notice_chat_top_notice_request.uri = "/open-apis/im/v1/chats/:chat_id/top_notice/put_top_notice"
        put_top_notice_chat_top_notice_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._put_top_notice_chat_top_notice_request: PutTopNoticeChatTopNoticeRequest = put_top_notice_chat_top_notice_request

    def chat_id(self, chat_id: str) -> "PutTopNoticeChatTopNoticeRequestBuilder":
        self._put_top_notice_chat_top_notice_request.chat_id = chat_id
        self._put_top_notice_chat_top_notice_request.paths["chat_id"] = str(chat_id)
        return self

    def request_body(self,
                     request_body: PutTopNoticeChatTopNoticeRequestBody) -> "PutTopNoticeChatTopNoticeRequestBuilder":
        self._put_top_notice_chat_top_notice_request.request_body = request_body
        self._put_top_notice_chat_top_notice_request.body = request_body
        return self

    def build(self) -> PutTopNoticeChatTopNoticeRequest:
        return self._put_top_notice_chat_top_notice_request
