# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class SearchChatRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.query: Optional[str] = None
        self.page_token: Optional[str] = None
        self.page_size: Optional[int] = None

    @staticmethod
    def builder() -> "SearchChatRequestBuilder":
        return SearchChatRequestBuilder()


class SearchChatRequestBuilder(object):

    def __init__(self) -> None:
        search_chat_request = SearchChatRequest()
        search_chat_request.http_method = HttpMethod.GET
        search_chat_request.uri = "/open-apis/im/v1/chats/search"
        search_chat_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._search_chat_request: SearchChatRequest = search_chat_request

    def user_id_type(self, user_id_type: str) -> "SearchChatRequestBuilder":
        self._search_chat_request.user_id_type = user_id_type
        self._search_chat_request.add_query("user_id_type", user_id_type)
        return self

    def query(self, query: str) -> "SearchChatRequestBuilder":
        self._search_chat_request.query = query
        self._search_chat_request.add_query("query", query)
        return self

    def page_token(self, page_token: str) -> "SearchChatRequestBuilder":
        self._search_chat_request.page_token = page_token
        self._search_chat_request.add_query("page_token", page_token)
        return self

    def page_size(self, page_size: int) -> "SearchChatRequestBuilder":
        self._search_chat_request.page_size = page_size
        self._search_chat_request.add_query("page_size", page_size)
        return self

    def build(self) -> SearchChatRequest:
        return self._search_chat_request
