# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class Sender(object):
    _types = {
        "id": str,
        "id_type": str,
        "sender_type": str,
        "tenant_key": str,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.id_type: Optional[str] = None
        self.sender_type: Optional[str] = None
        self.tenant_key: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SenderBuilder":
        return SenderBuilder()


class SenderBuilder(object):
    def __init__(self) -> None:
        self._sender = Sender()

    def id(self, id: str) -> "SenderBuilder":
        self._sender.id = id
        return self

    def id_type(self, id_type: str) -> "SenderBuilder":
        self._sender.id_type = id_type
        return self

    def sender_type(self, sender_type: str) -> "SenderBuilder":
        self._sender.sender_type = sender_type
        return self

    def tenant_key(self, tenant_key: str) -> "SenderBuilder":
        self._sender.tenant_key = tenant_key
        return self

    def build(self) -> "Sender":
        return self._sender
