# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class ToolkitCallback(object):
    _types = {
        "webhook": str,
        "action_key": str,
    }

    def __init__(self, d=None):
        self.webhook: Optional[str] = None
        self.action_key: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ToolkitCallbackBuilder":
        return ToolkitCallbackBuilder()


class ToolkitCallbackBuilder(object):
    def __init__(self) -> None:
        self._toolkit_callback = ToolkitCallback()

    def webhook(self, webhook: str) -> "ToolkitCallbackBuilder":
        self._toolkit_callback.webhook = webhook
        return self

    def action_key(self, action_key: str) -> "ToolkitCallbackBuilder":
        self._toolkit_callback.action_key = action_key
        return self

    def build(self) -> "ToolkitCallback":
        return self._toolkit_callback
